/**
* \file: handle_coldplug_devs_cmd.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include "handle_coldplug_devs_cmd/handle_coldplug_devs_cmd.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#define UDEVADM_PATH1 "/usr/bin/udevadm"
#define UDEVADM_TRIGGER_CMD1_1 "/usr/bin/udevadm trigger --type=subsystems --action=add --subsystem-match=block"
#define UDEVADM_TRIGGER_CMD1_2 "/usr/bin/udevadm trigger --type=devices --action=add --subsystem-match=block"

#define UDEVADM_PATH2 "/bin/udevadm"
#define UDEVADM_TRIGGER_CMD2_1 "/bin/udevadm trigger --type=subsystems --action=add --subsystem-match=block"
#define UDEVADM_TRIGGER_CMD2_2 "/bin/udevadm trigger --type=devices --action=add --subsystem-match=block"

#define UDEVADM_PATH3 "/usr/sbin/udevadm"
#define UDEVADM_TRIGGER_CMD3_1 "/usr/sbin/udevadm trigger --type=subsystems --action=add --subsystem-match=block"
#define UDEVADM_TRIGGER_CMD3_2 "/usr/sbin/udevadm trigger --type=devices --action=add --subsystem-match=block"

#define UDEVADM_PATH4 "/sbin/udevadm"
#define UDEVADM_TRIGGER_CMD4_1 "/sbin/udevadm trigger --type=subsystems --action=add --subsystem-match=block"
#define UDEVADM_TRIGGER_CMD4_2 "/sbin/udevadm trigger --type=devices --action=add --subsystem-match=block"

static error_code_t handle_coldplug_devs_cmd_parse_args(int argc, char *argv[]);
static error_code_t handle_coldplug_devs_cmd_start(void);
static void handle_coldplug_devs_cmd_print_help(void);

static error_code_t handle_coldplug_devs_cmd_parse_args(int argc, char *argv[])
{
	//no additional parameter given, so we can go on with the command
	if (argc==2)
		return RESULT_OK;

	//we can be sure that we have more than 2 parameters (automounterctl <command>) passed,
	//otherwise we would have never got here.
	if (strcmp(argv[2],"--help")==0 || strcmp(argv[2],"-h")==0)
	{
		handle_coldplug_devs_cmd_print_help();
		return RESULT_HELP_PRINTED;
	}

	//ignore parameters that do not fit to us.
	return RESULT_OK;
}

static void handle_coldplug_devs_cmd_print_help(void)
{
	printf("\n");
	printf("Automounter Control Utility - Used to control the ADIT automounter daemon.\n\n");
	printf("automounterctl %s [OPTIONS]\n",handle_coldplug_devs_cmd_vtable.command);
	printf("\t-h,--help:\t\tdisplays this help and exits.\n\n");
	printf("This command triggers the automounter daemon to automount all currently\n"
			"connected and supported mass storgage devices that are not blacklisted.\n"
			"Mass storage devices that are already mounted or have mounted partitions\n"
			"are not touched by the automounter.\n"
			"This command is normally executed during startup directly after the\n"
			"automounter daemon is started to detect and handle cold plugged mass\n"
			"storage devices.\n\n");
}

static error_code_t handle_coldplug_devs_cmd_start(void)
{
  struct stat udevadm_stat;
  if (stat(UDEVADM_PATH1,&udevadm_stat)==0)
    {
	if (system(UDEVADM_TRIGGER_CMD1_1)==-1)
		return RESULT_INVALID;
	if (system(UDEVADM_TRIGGER_CMD1_2)==-1)
		return RESULT_INVALID;
	return RESULT_OK;
    }

  if (stat(UDEVADM_PATH2,&udevadm_stat)==0)
    {
	if (system(UDEVADM_TRIGGER_CMD2_1)==-1)
		return RESULT_INVALID;
	if (system(UDEVADM_TRIGGER_CMD2_2)==-1)
		return RESULT_INVALID;
	return RESULT_OK;
    }
  if (stat(UDEVADM_PATH3,&udevadm_stat)==0)
    {
	if (system(UDEVADM_TRIGGER_CMD3_1)==-1)
		return RESULT_INVALID;
	if (system(UDEVADM_TRIGGER_CMD3_2)==-1)
		return RESULT_INVALID;
	return RESULT_OK;
    }
  if (stat(UDEVADM_PATH4,&udevadm_stat)==0)
    {
	if (system(UDEVADM_TRIGGER_CMD4_1)==-1)
		return RESULT_INVALID;
	if (system(UDEVADM_TRIGGER_CMD4_2)==-1)
		return RESULT_INVALID;
	return RESULT_OK;
    }
  printf("Unable to find udevadm. Searched for it in /bin/, /usr/bin, /sbin/, and /usr/sbin\n");

  return RESULT_INVALID;
}

automounterctl_command_vtable_t handle_coldplug_devs_cmd_vtable=
{
		.command_description="Triggers the automounter to handle mass storage devices already connected to the system.",
		.command="handle_coldplug_devs",
		.init=NULL,
		.parse_args=handle_coldplug_devs_cmd_parse_args,
		.start=handle_coldplug_devs_cmd_start,
		.deinit=NULL
};
